/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminCommon;
import filenet.vw.toolkit.admin.result.VWAdminConfirmWithCheckBoxDialog;
import filenet.vw.toolkit.admin.result.VWAdminConfirmYesNoCancelDialog;
import filenet.vw.toolkit.admin.result.VWAdminErrorDataObj;
import filenet.vw.toolkit.admin.result.VWAdminErrorsDialog;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminReturnWorkDialog;
import filenet.vw.toolkit.admin.result.VWAdminWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Container;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;

public class VWAdminReturnWork {
    private VWAdminResultPane m_resultsPane;
    private VWTable m_resultsTable;
    private VWAdminResultTableModelBase m_tableModel;
    private int[] m_selectedRows;
    private int[] m_selectedCols;
    private Frame m_parentFrame = null;
    private Container m_mainContainer = null;
    private Vector m_vErrors = new Vector();
    private boolean m_bOverride = false;

    public VWAdminReturnWork(VWAdminResultPane resultsPane) {
        this.m_resultsPane = resultsPane;
        this.m_selectedRows = this.m_resultsPane.getSelectedRows();
        this.m_selectedCols = this.m_resultsPane.getSelectedCols();
        this.m_tableModel = this.m_resultsPane.getTableModel();
        this.m_resultsTable = this.m_resultsPane.getResultsTable();
        this.m_mainContainer = this.m_resultsPane.getMainContainer();
        this.m_parentFrame = this.m_resultsPane.getParentFrame();
        Vector wobsList = new Vector();
        boolean bAll = false;
        wobsList = this.buildWobsList(this.m_selectedRows, bAll);
        if (wobsList.size() == 0) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_noWorkCanBeReturned, VWResource.s_returnWorkDlgTitle, 1, null);
            return;
        }
        boolean bCancel = this.checkForSaveAndOverride(this.m_selectedRows);
        if (bCancel) {
            this.removeReferences();
            return;
        }
        this.doLock(wobsList);
        this.m_tableModel.refreshSelectedRows(this.m_selectedRows);
        if (this.m_vErrors.size() != 0) {
            VWAdminErrorsDialog errorDlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_returnWorkDlgTitle, VWResource.s_lockErr, this.m_vErrors);
            errorDlg.setVisible(true);
            this.removeReferences();
            return;
        }
        VWAdminReturnWorkDialog dlg = new VWAdminReturnWorkDialog(wobsList, this.m_resultsPane);
        dlg.setVisible(true);
        this.doUnlock(wobsList);
        this.m_tableModel.refreshSelectedRows(this.m_selectedRows);
        if (this.m_vErrors.size() != 0) {
            VWAdminErrorsDialog errorDlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_returnWorkDlgTitle, VWResource.s_unlockErr, this.m_vErrors);
            errorDlg.setVisible(true);
        }
        this.removeReferences();
    }

    private Vector buildWobsList(int[] rows, boolean bAll) {
        Vector<VWAdminWorkObjectTableData> wobsList = new Vector<VWAdminWorkObjectTableData>();
        try {
            for (int i = 0; i < rows.length; ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(rows[i]);
                if (bAll) {
                    wobsList.addElement(woData);
                } else {
                    VWWorkObject wob = woData.getWob();
                    if (wob.fetchStepElement().getCanReturnToSource()) {
                        wobsList.addElement(woData);
                    }
                }
                this.addChildrenToWobsList(woData.getChildren(), wobsList, bAll);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return wobsList;
    }

    private void addChildrenToWobsList(Vector v_children, Vector wobsList, boolean bAll) {
        try {
            if (v_children.size() == 0) {
                return;
            }
            for (int i = 0; i < v_children.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)v_children.elementAt(i);
                if (bAll) {
                    wobsList.addElement(woData);
                    continue;
                }
                VWWorkObject wob = woData.getWob();
                if (!wob.fetchStepElement().getCanReturnToSource()) continue;
                wobsList.addElement(woData);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void doRefresh(Vector wobsList) {
        VWAdminWorkObjectTableData woData;
        int i;
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWWorkObject wob = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        for (i = 0; i < wobsList.size(); ++i) {
            woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
            if (woData.getLockedStatus() != 1) continue;
            woVector.addElement(woData.getWob());
        }
        if (woVector.size() != 0) {
            woArray = new VWWorkObject[woVector.size()];
            for (i = 0; i < woVector.size(); ++i) {
                woArray[i] = (VWWorkObject)woVector.elementAt(i);
            }
            for (i = 0; i < woArray.length; ++i) {
                try {
                    wob = woArray[i];
                    wob.doRefresh(true, true);
                    woData = VWAdminCommon.findWoData(wob, wobsList);
                    if (woData == null) continue;
                    woData.setDirty(false);
                    woData.updateLockedInfo();
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    private void doSave(Vector wobsList) {
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWException[] arrayExceptions = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_tableModel instanceof VWAdminWOInRosterTableModel) {
            for (int i = 0; i < wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
                if (woData.getLockedStatus() != 1 || !woData.isDirty()) continue;
                VWWorkObject wob = woData.getWob();
                try {
                    wob.doSave(false);
                    wob.doRefresh(true, true);
                    woData.setDirty(false);
                    woData.updateLockedInfo();
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
        } else {
            int i;
            int i2;
            for (i2 = 0; i2 < wobsList.size(); ++i2) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i2);
                if (woData.getLockedStatus() != 1 || !woData.isDirty()) continue;
                woVector.addElement(woData.getWob());
            }
            if (woVector.size() != 0) {
                woArray = new VWWorkObject[woVector.size()];
                for (i2 = 0; i2 < woVector.size(); ++i2) {
                    woArray[i2] = (VWWorkObject)woVector.elementAt(i2);
                }
                try {
                    VWWorkObject curWorkObject = woArray[0];
                    arrayExceptions = VWWorkObject.doSaveMany(woArray);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            } else {
                return;
            }
            for (i = 0; i < woArray.length; ++i) {
                VWWorkObject wob = woArray[i];
                try {
                    if (arrayExceptions[i] == null) {
                        wob.doRefresh(true, true);
                        VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, wobsList);
                        if (woData == null) continue;
                        woData.setDirty(false);
                        woData.updateLockedInfo();
                        continue;
                    }
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(arrayExceptions[i]);
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (arrayExceptions != null) {
                for (i = 0; i < arrayExceptions.length; ++i) {
                    arrayExceptions[i] = null;
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    private void doLock(Vector wobsList) {
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWException[] arrayExceptions = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_tableModel instanceof VWAdminWOInRosterTableModel) {
            for (int i = 0; i < wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
                if (woData.getLockedStatus() == 1) continue;
                VWWorkObject wob = woData.getWob();
                try {
                    wob.doLock(this.m_bOverride);
                    wob.doRefresh(true, true);
                    woData.updateLockedInfo();
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
        } else {
            int i;
            int i2;
            for (i2 = 0; i2 < wobsList.size(); ++i2) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i2);
                int lockedStatus = woData.getLockedStatus();
                if (woData.getLockedStatus() == 1) continue;
                woVector.addElement(woData.getWob());
            }
            if (woVector.size() != 0) {
                woArray = new VWWorkObject[woVector.size()];
                for (i2 = 0; i2 < woVector.size(); ++i2) {
                    woArray[i2] = (VWWorkObject)woVector.elementAt(i2);
                }
                try {
                    VWWorkObject curWorkObject = woArray[0];
                    arrayExceptions = VWWorkObject.doLockMany(woArray, this.m_bOverride);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            } else {
                return;
            }
            for (i = 0; i < woArray.length; ++i) {
                VWWorkObject wob = woArray[i];
                try {
                    if (arrayExceptions[i] == null) {
                        wob.doRefresh(true, true);
                        VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, wobsList);
                        if (woData == null) continue;
                        woData.updateLockedInfo();
                        continue;
                    }
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(arrayExceptions[i]);
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (arrayExceptions != null) {
                for (i = 0; i < arrayExceptions.length; ++i) {
                    arrayExceptions[i] = null;
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    private void doUnlock(Vector wobsList) {
        boolean bDispatch = false;
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWException[] arrayExceptions = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_tableModel instanceof VWAdminWOInRosterTableModel) {
            for (int i = 0; i < wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
                if (woData.getLockedStatus() != 1) continue;
                VWWorkObject wob = woData.getWob();
                try {
                    wob.doSave(true);
                    wob.doRefresh(false, false);
                    woData.setDirty(false);
                    woData.updateLockedInfo();
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
        } else {
            int i;
            int i2;
            for (i2 = 0; i2 < wobsList.size(); ++i2) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i2);
                if (woData.getLockedStatus() != 1) continue;
                woVector.addElement(woData.getWob());
            }
            if (woVector.size() != 0) {
                woArray = new VWWorkObject[woVector.size()];
                for (i2 = 0; i2 < woVector.size(); ++i2) {
                    woArray[i2] = (VWWorkObject)woVector.elementAt(i2);
                }
                try {
                    VWWorkObject curWorkObject = woArray[0];
                    arrayExceptions = VWWorkObject.doUnlockMany(woArray, true, false);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            } else {
                return;
            }
            for (i = 0; i < woArray.length; ++i) {
                VWWorkObject wob = woArray[i];
                try {
                    if (arrayExceptions[i] == null) {
                        wob.doRefresh(false, false);
                        VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, wobsList);
                        if (woData == null) continue;
                        woData.setDirty(false);
                        woData.updateLockedInfo();
                        continue;
                    }
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(arrayExceptions[i]);
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (arrayExceptions != null) {
                for (i = 0; i < arrayExceptions.length; ++i) {
                    arrayExceptions[i] = null;
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    private boolean checkForSaveAndOverride(int[] rows) {
        boolean bCancel = true;
        boolean bSave = false;
        Vector wobsList = new Vector();
        boolean bAll = true;
        wobsList = this.buildWobsList(rows, bAll);
        boolean bLockedByOthers = VWAdminCommon.isAnyLockedByOthers(wobsList);
        boolean bModified = VWAdminCommon.isAnyWorkModified(wobsList);
        if (bLockedByOthers || bModified) {
            if (bLockedByOthers && bModified) {
                VWAdminConfirmWithCheckBoxDialog confirmDlg = new VWAdminConfirmWithCheckBoxDialog(this.m_parentFrame, VWResource.s_returnWorkDlgTitle, VWResource.s_confirmSaveMessageBeforeReturn, VWResource.s_override, 0);
                confirmDlg.setVisible(true);
                if (confirmDlg.isCanceled()) {
                    if (wobsList != null) {
                        wobsList.removeAllElements();
                    }
                    return bCancel;
                }
                this.m_bOverride = confirmDlg.isChecked();
                bSave = confirmDlg.isYes();
            } else if (bLockedByOthers) {
                VWAdminConfirmYesNoCancelDialog dlg = new VWAdminConfirmYesNoCancelDialog(this.m_parentFrame, VWResource.s_returnWorkDlgTitle, VWResource.s_confirmOverride, 0);
                dlg.setVisible(true);
                if (dlg.isCanceled()) {
                    if (wobsList != null) {
                        wobsList.removeAllElements();
                    }
                    return bCancel;
                }
                this.m_bOverride = dlg.isYes();
                bSave = false;
            } else if (bModified) {
                VWAdminConfirmYesNoCancelDialog saveDlg = new VWAdminConfirmYesNoCancelDialog(this.m_parentFrame, VWResource.s_returnWorkDlgTitle, VWResource.s_confirmSaveMessageBeforeReturn, 0);
                saveDlg.setVisible(true);
                if (saveDlg.isCanceled()) {
                    if (wobsList != null) {
                        wobsList.removeAllElements();
                    }
                    return bCancel;
                }
                this.m_bOverride = true;
                bSave = saveDlg.isYes();
            }
        } else {
            this.m_bOverride = true;
        }
        if (bSave) {
            this.doSave(wobsList);
        } else {
            this.doRefresh(wobsList);
        }
        this.m_tableModel.refreshSelectedRows(rows);
        if (this.m_vErrors.size() != 0) {
            VWAdminErrorsDialog errorDlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_returnWorkDlgTitle, VWResource.s_saveErr, this.m_vErrors);
            errorDlg.setVisible(true);
            if (wobsList != null) {
                wobsList.removeAllElements();
            }
            return bCancel;
        }
        if (wobsList != null) {
            wobsList.removeAllElements();
        }
        return false;
    }

    private void removeReferences() {
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
    }
}

